import java.io.*;

/**
 * Classe contenente tutte le info utili dei due javaRegistry
 * @author Letizia Cheng Cheng Sun
 * @version 1.0
 *
 *
 */
public class RegistryInfo implements Serializable{
	static protected int secondLevelPortNum=1111;//valore di default
	protected int firstLevelPortNum;
	protected String host;
	protected String serviceName;
	
	/**
	 * Costruttore di default che inizializza le variabili:
	 * firstLevelPortNum, porta del registro di primo livello, al valore 1099
	 * secondLevelPortNum, porta del registro di secondo livello, al valore 1111
	 * host con il valore "localhost"
	 * serviceName con il valore "newsgroup"
	 *
	 */
	public RegistryInfo(){
		firstLevelPortNum=1099;
		host="localhost";
		serviceName="newsgroup";
	}
	
	/**
	 * Costruttore a 4 parametri in cui tutti i valori necessari sono esplicitati
	 * @param f numero della porta del registro di primo livello
	 * @param s numero della porta del registro di secondo livello
	 * @param h stringa che indica l'indirizzo dell'host
	 * @param sN Stringa che contiene il nome del servizio
	 */
	public RegistryInfo(int f, int s,String h, String sN){
		firstLevelPortNum=f;
		secondLevelPortNum=s;
		host=h;
		serviceName=sN;
	}
	
	/**
	 * Costruttore a 3 parametri ove non si conosce il nome del
	 * servizio, perch ancora sconociuto
	 * @param f numero della porta del registro di primo livello
	 * @param s numero della porta del registro di secondo livello
	 * @param h stringa che indica l'indirizzo dell'host
	 */
	public RegistryInfo(int f, int s,String h){
		firstLevelPortNum=f;
		secondLevelPortNum=s;
		host=h;
		serviceName=null;
	}
	
	/**
	 * Costruttore a 3 parametri,ove non si conosce il numero 
	 * della porta del registry di secondo livello
	 * @param f numero della porta del registro di primo livello
	 * @param h stringa che indica l'indirizzo dell'host
	 * @param sN Stringa che contiene il nome del servizio
	 */
	public RegistryInfo(int f,String h, String sN){
		firstLevelPortNum=f;
		host=h;
		serviceName=sN;
	}
	
	/**
	 * Metodo che ritorna il numero della porta di primo livello
	 * @return numero della porta del registro di primo livello
	 */
	public int getFirstLevelPortNumber(){
		return firstLevelPortNum;
	}
	
	/**
	 * Metodo che ritorna il numero della porta di secondo livello
	 * @return numero della porta del registro di secondo livello
	 */
	public static int getSecondLevelPortNum(){
		return secondLevelPortNum;
	}

	
	/**
	 * Metodo che ritorna il nome del servizio registrato nel registry
	 * @return il nome del servizio registrato nel registry
	 */
	public String getServiceName(){
		return serviceName;
	}
	
	/**
	 * Metodo che ritorna l'host
	 * @return valore dell'host
	 */
	public String getHost(){
		return host;
	}
}
